/*\file InternalFront.c
 *\brief: build pressureload
 */

#include "./InternalFront.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	bool*   elementonwater=NULL;
	int*    elements=NULL;
	int*    connectivity=NULL;
	int*    elementconnectivity=NULL;
	int*    front=NULL;
	double* front2=NULL;
	int     numberofelements;
	int     N,M;
	int     numberofsegments;
	int     id,node1,node2;
	int     i,j,ii,jj;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InternalFrontUsage);

	/*Fetch required fields*/
	FetchData(&numberofelements,mxGetAssignedField(MODEL,0,"numberofelements"));
	if(numberofelements<=0) _error_("No elements found in the model");
	FetchData(&elements,&M,&N,mxGetAssignedField(MODEL,0,"elements"));
	if(M!=numberofelements || N!=3) _error_("Field 'elements' should be of size [md.numberofelements 3]");
	FetchData(&elementonwater,&M,&N,mxGetAssignedField(MODEL,0,"elementonwater"));
	if(M!=numberofelements || N!=1) _error_("Field 'elementonwater' should be of size [md.numberofelements 1]");
	FetchData(&elementconnectivity,&M,&N,mxGetAssignedField(MODEL,0,"elementconnectivity"));
	if(M!=numberofelements || N!=3) _error_("Field 'elementconnectivity' should be of size [md.numberofelements 3]");

	/*Allocate and initialize all variables*/
	numberofsegments=0;
	front=(int*)xmalloc(3*numberofelements*4*sizeof(int));

	/*Loop over all elements on water*/
	for(i=0;i<numberofelements;i++){

		/*Skip if on water*/
		if(!elementonwater[i]) continue;

		/*Loop over all three adjacent elements*/
		for(j=0;j<3;j++){

			/*Skip if adjacent element does not exist or is on water*/
			id=elementconnectivity[i*3+j];
			if(id==0) continue;
			if(elementonwater[id-1]) continue;

			/*We have an ice front to add here, let's go!*/
			node1=node2=0;
			for(ii=0;ii<3;ii++){
				for(jj=0;jj<3;jj++){
					if(elements[(id-1)*3+ii]==elements[i*3+jj]){
						if(node1==0){
							node1=elements[(id-1)*3+ii];
						}
						else{
							node2=elements[(id-1)*3+ii]; break;
						}
					}
				}
			}
			_assert_(node1 && node2);
			front[numberofsegments*4+0]=node1;
			front[numberofsegments*4+1]=node2;
			front[numberofsegments*4+2]=id;
			front[numberofsegments*4+3]=IceEnum;
			numberofsegments+=1;
		}
	}

	/*Now that we know how many segments there is we can allocate the final matrix*/
	front2=(double*)xmalloc(4*numberofsegments*sizeof(double));
	for(i=0;i<4*numberofsegments;i++) front2[i]=(double)front[i];
	xfree((void**)&front);

	/*write output datasets: */
	WriteData(FRONT,front2,numberofsegments,4);

	/*end module: */
	MODULEEND();
}

void InternalFrontUsage(void) {
	_printf_(true,"\n");
	_printf_(true,"   usage: icefront = %s(md);\n",__FUNCT__);
	_printf_(true,"\n");
}
