/*!\file ControlInputGetGradientx
 * \brief retrieve gradient from inputs in elements
 */

#include "./ControlInputGetGradientx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void ControlInputGetGradientx( Vec* pgradient, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters, int name){

	Vec gradient=NULL;
	gradient=NewVec(vertices->NumberOfVertices());

	for(int i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->ControlInputGetGradient(gradient,name);
	}

	VecAssemblyBegin(gradient);
	VecAssemblyEnd(gradient);

	/*Assign output pointers:*/
	*pgradient=gradient;
}
