%STARTUP - Matlab startup script
%
%   startup.m is a script run by matlab at the beginning of a session, just before 
%   handing over the prompt to the user. This delivery startup.m script has been customized here for 
%   the ISSM code. This startup script should be run by users before trying to use ISSM. The best way 
%   to do that is to put the startup file in the location where Matlab starts and established its root
%   directory.
%
%   Copyright Jet Propulsion Laboratory. 

% clear the last warning to focus on the warnings of the ISSM path
lastwarn(''); 

%Recover ISSM_TIER, ISSM_DIR  and USERNAME
ISSM_TIER=getenv('ISSM_TIER');
USERNAME =getenv('USER');
if (isempty(ISSM_TIER)),
	error('issmdir error message: ''ISSM_TIER'' environment variable is empty! You should define ISSM_TIER in your .cshrc or .bashrc!');
end

%Now add all issm code paths necessary to run issm smoothly. 
%We capture the error output, so that we can warn the user to update 
%the variable ISSM_TIER in this file, in case it is not correctly setup. 

%ISSM path
addpath([ISSM_TIER '/src/m/utils/']); %loads genpath_ice
addpath([ISSM_TIER '/doc']);
addpath([ISSM_TIER '/bin']);
addpath(genpath_ice([ISSM_TIER '/src/m']));
addpath(genpath_ice([ISSM_TIER '/externalpackages/scotch']));
addpath(genpath_ice([ISSM_TIER '/externalpackages/canos']));
addpath(genpath_ice([ISSM_TIER '/externalpackages/kml']));

%Check on any warning messages that might indicate that the paths were not correct. 
if ~isempty(lastwarn),
	fprintf('\n  Error trying to setup ''ISSM'' code paths. Try and update the ISSM_TIER variable in your .cshrc or .bashrc!\n');
	fprintf('  ''ISSM'' will not  work at all until this is resolved\n\n');
else
	fprintf('\n  To get started with ISSM, type issmdoc at the command prompt.\n\n');
end

%  deal with Matlab bug (on Linux, not WinXP) -- unless
%  the class has been called, "empty" method can not be found
normal_uncertain;
continuous_design;
continuous_state;
linear_inequality_constraint;
linear_equality_constraint;
response_function;
objective_function;
least_squares_term;
nonlinear_inequality_constraint;
nonlinear_equality_constraint;
clear ans;

%Now, load personal startup preferences, using the local user name: 
rmpath(genpath_ice([ISSM_TIER '/src/m/usr']));
if exist([ISSM_TIER '/src/m/usr/' USERNAME],'dir'),
	addpath(genpath_ice([ISSM_TIER '/src/m/usr/' USERNAME]));
end
clear USERNAME ISSM_TIER;

%disable matlab bell!
beep off;
