/*!\file: CreateParametersThermal.cpp
 * \brief driver for creating parameters dataset, for diagnostic horiz analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParametersThermal"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"

void CreateParametersThermal(DataSet** pparameters,Model* model,ConstDataHandle model_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int i;

	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	double* pressure=NULL;
	double* temperature=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Get vx vy and vz: */
	ModelFetchData((void**)&vx,NULL,NULL,model_handle,"vx","Matrix","Mat");
	ModelFetchData((void**)&vy,NULL,NULL,model_handle,"vy","Matrix","Mat");
	ModelFetchData((void**)&vz,NULL,NULL,model_handle,"vz","Matrix","Mat");

	if(vx) for(i=0;i<model->numberofnodes;i++)vx[i]=vx[i]/model->yts;
	if(vy) for(i=0;i<model->numberofnodes;i++)vy[i]=vy[i]/model->yts;
	if(vz) for(i=0;i<model->numberofnodes;i++)vz[i]=vz[i]/model->yts;

	count++;
	param= new Param(count,"vx",DOUBLEVEC);
	if(vx) param->SetDoubleVec(vx,model->numberofnodes);
	else param->SetDoubleVec(vx,0);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"vy",DOUBLEVEC);
	if(vy) param->SetDoubleVec(vy,model->numberofnodes);
	else param->SetDoubleVec(vy,0);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"vz",DOUBLEVEC);
	if(vz) param->SetDoubleVec(vz,model->numberofnodes);
	else param->SetDoubleVec(vz,0);
	parameters->AddObject(param);

	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);
	
	/*Get pressure: */
	ModelFetchData((void**)&pressure,NULL,NULL,model_handle,"pressure","Matrix","Mat");
	
	count++;
	param= new Param(count,"pressure",DOUBLEVEC);
	if(pressure) param->SetDoubleVec(pressure,model->numberofnodes);
	else param->SetDoubleVec(pressure,0);
	parameters->AddObject(param);

	/*Free pressure: */
	xfree((void**)&pressure);

	/* get initial temperature if transient*/
	if(strcmp(model->sub_analysis_type,"transient")==0){

		/*Get melting and temperature: */
		ModelFetchData((void**)&temperature,NULL,NULL,model_handle,"temperature","Matrix","Mat");

		count++;
		param= new Param(count,"temperature",DOUBLEVEC);
		if(temperature) param->SetDoubleVec(temperature,model->numberofnodes);
		else throw ErrorException(__FUNCT__,exprintf("Missing initial temperature"));
		parameters->AddObject(param);

		/*Free temperature: */
		xfree((void**)&temperature);
	}
	
	/*Assign output pointer: */
	*pparameters=parameters;
}
