%%
%  create kml linestrings for the unshared element edges.
%
%  [kfold]=kml_unsh_edges(md,params)
%
%  where the required input is:
%    md            (model, model class object)
%
%  the optional input is:
%    params        (string/numeric, parameter names and values)
%
%  and the optional input is:
%    alt           (numeric, altitude for polygons, default 10000)
%    prtplt        (char, 'off'/'no' for partition edge plot)
%
%  and the required output is:
%    kfold         (kml_folder, folder of linestring placemarks)
%
function [kfold]=kml_unsh_edges(varargin)

if ~nargin
    help kml_unsh_edges
    return
end

%%  process input data

iarg=1;
if (nargin >= 1)
    md=varargin{1};
end
if ~exist('md','var') || isempty(md) || ~isa(md,'model')
    error(['Model ''' inputname(iarg) ''' is unrecognized class ''' class(md) '''.']);
end

%  parameters

iarg=iarg+1;
while (iarg <= nargin-1)
    if ischar(varargin{iarg})
        eval([varargin{iarg} '=varargin{iarg+1};']);
        if (numel(varargin{iarg+1}) <= 20)
            disp([varargin{iarg} '=' any2str(varargin{iarg+1}) ';']);
        else
            disp([varargin{iarg} '=' string_size(varargin{iarg+1}) ' ' class(varargin{iarg+1}) ';']);
        end
    else
        error(['''' any2str(varargin{iarg}) ''' is not a parameter name.']);
    end
    iarg=iarg+2;
end

if ~exist('alt','var')
    alt=10000;
end

%%  write folder for unshared edges

if (~exist('prtplt','var') || strncmpi(prtplt,'on' ,2) || strncmpi(prtplt,'y',1)) && ...
    md.npart
    [edgeadj]=edgeadjacency(md.elements,md.nodeconnectivity);
    [icol,irow]=find(edgeadj'==0);
    edgeuns=zeros(length(irow),2);
    for i=1:length(irow)
        edgeuns(i,1)=md.elements(irow(i),icol(i));
        edgeuns(i,2)=md.elements(irow(i),mod(icol(i),size(md.elements,2))+1);
    end
    kfold=kml_folder();
    kfold.name      ='Unshared Edges';
    kfold.visibility=1;
    kfold.descript  =sprintf('Partitions=%d, Edges=%d',...
        md.npart,size(edgeuns,1));
    kfold.feature   ={repmat(kml_placemark(),1,size(edgeuns,1))};

%  write each edge as a linestring placemark

    disp(['Writing ' num2str(size(edgeuns,1)) ' unshared edges as KML linestrings.']);
    for i=1:size(edgeuns,1)
        kplace=kml_placemark();
        kplace.name      =sprintf('Edge %d',i);
        kplace.visibility=1;
        kplace.styleurl  ='#RedLineRedPoly';

        kline=kml_linestring();
        kline.extrude   =1;
        kline.tessellate=1;
        kline.altmode   ='relativeToGround';
        kline.coords    =zeros(2,3);

        for j=1:2
            [lat,long]=xy2ll(md.x(edgeuns(i,j)),md.y(edgeuns(i,j)),-1);
            kline.coords(j,:)=[long lat alt];
        end

        kplace.geometry=kline;
        kfold.feature{1}(i)=kplace;
        clear kline kplace
    end
end

end

