function updatearchive(varargin)
% This file can be run to update the velocity archives  of the test1.
% This test deals with an icesheet without icefront for a 2d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

% The archive files will be saved in this directory but will not commited to ice1. 
% Just commit the result if you want to.

%packages and analysis_types to be tested
if nargin==1,
	packages=varargin{1};
else
	packages={'macayeal','ice','cielo_serial','cielo_parallel'};
end
solutions={'diagnostic','prognostic'};

%go through the solutions requested
testname='IceSheetNoIceFrontHM2d_14';
for i=1:length(packages),
	package=packages{i};

	for j=1:length(solutions),
		solution=solutions{j};

		%check solution requested
		if ((strcmpi(package,'cielo_parallel') & strcmpi(solution,'diagnostic'))| strcmpi(solution,'transient') | strcmpi(package,'macayeal')),
			disp(sprintf(['\nsolution: ' solution  ', with package: ' package  ', in test: ' testname  ', not supported yet.\n']));
			continue
		end

		%initialize model
		md=model;
		md=mesh(md,'DomainOutline.exp',50000);
		md=geography(md,'','');
		md=parameterize(md,'Square.par');
		md=setelementstype(md,'hutter','Hutter.exp','fill','MacAyeal');
		if md.numberofgrids==388
			load Velocities; md.vx=0.5*vx; md.vy=0.5*vy;
		end

		%compute solution
		[analysis_type sub_analysis_type]=testsgetanalysis(solution);
		[md packagefinal]=testsgetpackage(md,package);
		md=solve(md,'analysis_type',analysis_type,'sub_analysis_type',sub_analysis_type,'package',packagefinal);

		%compute fields to be checked
		fields=testsgetfields(md.type,solution);

		%save new archive
		for k=1:length(fields),
			field=fields{k};
			eval(['Archive' package solution '_field' num2str(k) '=md.results. ' field  ';']);
		end
		eval(['save Archive' package solution ' Archive' package solution '_field*']);
	end
end
