/*!\file GroundingLineMigrationx
 * \brief: migration grounding line position.
 */

#include "./GroundingLineMigrationx.h"
#include "./GroundingLineMigrationxLocal.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void GroundingLineMigrationx(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters){

	int i,j;
	Element* element=NULL;
	double* element_touching_iceshelf=NULL;

	_printf_(VerboseModule(),"   Migrating grounding line\n");

	/*Create  vector holding  all the elements that touch the ice shelf: */
	element_touching_iceshelf=CreateElementTouchingIceShelf(elements);

	/*Carry out grounding line migration for those elements: */
	for(i=0;i<elements->Size();i++){
		if (element_touching_iceshelf[i]){
			element=(Element*)elements->GetObjectByOffset(i);
			element->MigrateGroundingLine();
		}
	}

	/*Now, update shelf flags in nodes and elements. We could not do this before, 
	 *because we would end up with discontinuous bed and surface otherwise: */
	for(i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->UpdateShelfStatus();
	}

	/*free ressouces: */
	xfree((void**)&element_touching_iceshelf);
}
