/*!\file CreateElementTouchingIceShelf
 * \brief: create element on ice shelf, double* vector, from elements, serialized on all cpus.
 */

#include "./GroundingLineMigrationxLocal.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

double* CreateElementTouchingIceShelf(Elements* elements){

	int i;
	Element* element=NULL;
	Vec vec_element_touching_iceshelf=NULL;
	double* element_touching_iceshelf=NULL;

	/*Create  vector holding  all the elements IsOnShelf flags: */
	vec_element_touching_iceshelf=NewVec(elements->NumberOfElements(),true);

	/*Loop through elements, and fill vec_element_touching_iceshelf: */
	for(i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		VecSetValue(vec_element_touching_iceshelf,element->Sid(),(int)element->IsNodeOnShelf(),INSERT_VALUES);
	}

	/*Assemble vector: */
	VecAssemblyBegin(vec_element_touching_iceshelf);
	VecAssemblyEnd(vec_element_touching_iceshelf);

	/*Serialize vector: */
	VecToMPISerial(&element_touching_iceshelf,vec_element_touching_iceshelf);

	/*free ressouces: */
	VecFree(&vec_element_touching_iceshelf);

	return element_touching_iceshelf;
}
