/*!\file CreateElementOnIceShelf
 * \brief: create element on ice shelf, double* vector, from elements, serialized on all cpus.
 */

#include "./GroundingLineMigrationxLocal.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

double* CreateElementOnIceShelf(Elements* elements){

	int i;
	Element* element=NULL;
	Vec vec_element_on_iceshelf=NULL;
	double* element_on_iceshelf=NULL;

	/*Create  vector holding  all the elements IsOnShelf flags: */
	vec_element_on_iceshelf=NewVec(elements->NumberOfElements(),true);

	/*Loop through elements, and fill vec_element_on_iceshelf: */
	for(i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		VecSetValue(vec_element_on_iceshelf,element->Sid(),(int)element->IsOnShelf(),INSERT_VALUES);
	}

	/*Assemble vector: */
	VecAssemblyBegin(vec_element_on_iceshelf);
	VecAssemblyEnd(vec_element_on_iceshelf);

	/*Serialize vector: */
	VecToMPISerial(&element_on_iceshelf,vec_element_on_iceshelf);

	/*free ressouces: */
	VecFree(&vec_element_on_iceshelf);

	return element_on_iceshelf;
}
