radius=1e6;
shelfextent=2e5;
resolution=.5e5;

%mesh {{{1
md=roundmesh(model,radius,resolution);
%fix center grid to 0,0
rad=sqrt((md.x).*md.x+(md.y).*md.y);
pos=find(rad==min(rad));
md.x(pos)=0; md.y(pos)=0; %the closest node to the center is changed to be exactly at the center
%}}}
%put our grounding line 'shelfextent' meters from the icefront {{{1
xelem=md.x(md.elements)*[1;1;1]/3;
yelem=md.y(md.elements)*[1;1;1]/3;
rad=sqrt((xelem).*xelem+(yelem).*yelem);
flags=zeros(md.numberofelements,1);
pos=find(rad>=(radius-shelfextent));
flags(pos)=1;
flags2=zeros(md.numberofelements,1);
md=geography(md,flags,flags2); 
%}}}
md=parameterize(md,'../Par/RoundSheetShelf.par');
md=setelementstype(md,'macayeal','all');
md=SetParallel(md,3);
md=solve(md,'analysis_type',Transient2DSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'ElementOnIceShelf','Vx50','Vy50','Vel50'};
field_tolerances={1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.Transient2DSolution(50).ElementOnIceShelf),...
	PatchToVec(md.results.Transient2DSolution(50).Vx),...
	PatchToVec(md.results.Transient2DSolution(50).Vy),...
	PatchToVec(md.results.Transient2DSolution(50).Vel),...
	};
