function displaymaterials(md)
%DISPLAYCONTROL - display material parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays material parameters from model md, 
%   only if requested.
%
%   Usage:
%      displaymaterials(md)

fprintf('   Materials:\n');
fprintf('      rho_ice: %g [kg/m^3]\n',md.rho_ice);
fprintf('      rho_water: %g [kg/m^3]\n',md.rho_water);
if isempty(md.B), fprintf('      B: N/A (flow law parameter)'); else fprintf('      B: (%i) (flow law parameter [Pa/s^(1/n)])\n',length(md.B)); end
if isempty(md.n), fprintf('      n: N/A (flow law coefficient)'); else fprintf('      n: (%i) (flow law coefficient)\n',length(md.n)); end
fprintf('      heatcapacity: %g [J/kg/K]\n',md.heatcapacity);
fprintf('      thermalconductivity: %g [W/m/K]\n',md.thermalconductivity);
fprintf('      meltingpoint: %g [K] (melting point of ice at 1atm in K)\n',md.meltingpoint);
fprintf('      latentheat: %g [J/kg] (latent heat of fusion)\n',md.latentheat);
fprintf('      beta: %g [K/Pa]\n',md.beta);
fprintf('      mixed_layer_capacity: %g [W/kg/K]\n',md.mixed_layer_capacity);
fprintf('      thermal_exchange_velocity: %g [m/s]\n',md.thermal_exchange_velocity);
