function displaysolutionparameters(md)
%DISPLAYSOLUTIONPARAMETERS - display solution parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays the solution parameters
%   from model md, only if requested.
%
%   Usage:
%      displaysolutionparameters(md)

fprintf('   Solution parameters:\n');
fprintf('\n      statics:\n');
fprintf('         %s\n','Newton convergence criteria');
fprintf('            eps_rel: %g      (velocity relative convergence criterion)\n',md.eps_rel);
fprintf('            eps_abs: %g      (velocity absolute convergence criterion [m/yr], NaN -> no absolute criterion)\n',md.eps_abs);
fprintf('            viscosity_overshoot: %g      (over-shooting constant new=new+C*(new-old))\n',md.viscosity_overshoot);
fprintf('         penalty_offset: %g      (offset used by penalties: penalty = Kmax*10^offset)\n',md.penalty_offset);
fprintf('         penalty_melting: %g      (penalty used to keep T<Tpmp)\n',md.penalty_melting);
fprintf('         penalty_lock: %g      (counter used to lock penalties that zig zag)\n',md.penalty_lock);
fprintf('         lowmem: %i      (Set to 1 if you are running low on cluster memory)\n',md.lowmem);
fprintf('         sparsity: %g      (matrix sparsity. Set to .001 for < 1M dof, .0001 for 5M dof, and .00001 for > 10M dof\n',md.sparsity);
fprintf('         connectivity: %i      (element connectivity)\n',md.connectivity); 
fprintf('         debug: %i      (output debug statements when possible yes-> 1, no -> 0. Default is 1\n',md.debug);
fprintf('         element_debug: %i      (output debug statements for elementswhen possible yes-> 1, no -> 0. Default is 0\n',md.element_debug);
fprintf('         element_debugid: %i      (if element_debug on, id of element for which to output messages\n',md.element_debugid);
fprintf('         debug: %i      (output debug statements when possible yes-> 1, no -> 0. Default is 1');
fprintf('      ''%s''\n','transient');
fprintf('         dt: %g ( time step in years)\n',md.dt/md.yts);
fprintf('         ndt: %g ( time span in years)\n',md.ndt/md.yts);
fprintf('         artificial_diffusivity: %i (yes->1, no->0)\n',md.artificial_diffusivity);
fprintf('         minh: %g (minimum thickness to avoid stiffness singularity)\n',md.minh);
fprintf('         timestepping: %i ( adptative time stepping implemented - default to 0)\n',md.timestepping);
fprintf('         deltaH: %g ( minimum thickness difference between two time steps)\n',md.deltaH);
fprintf('         DeltaH: %g ( maximum thickness difference between two time steps)\n',md.DeltaH);
fprintf('         deltaT: %g ( minimum temperature difference between two time steps)\n',md.deltaT);
fprintf('         DeltaT: %g ( maximum temperature difference between two time steps)\n',md.DeltaT);
fprintf('         timeacc: %g ( multiplier to time step when time stepping increases time step)\n',md.timeacc);
fprintf('         timedec: %g ( multiplier to time step when time stepping decresaes time step)\n',md.timedec);

fprintf('\n      control:\n');
fprintf('         control_type: %s (control type, ex: ''drag'', or ''B'')\n',md.control_type);
fprintf('         fit: (%g)      ( 0 -> absolute, 1 -> relative, 2 -> logarithmic. default is absolute)\n',length(md.fit));
fprintf('         meanvel: %g      (velocity scaling factor when evaluating relative or logarithmic misfit)\n',md.meanvel);
fprintf('         epsvel: %g      ( for relative fit, avoids misfit becoming infinity, for logarithmic fit, threshold for velocity)\n',md.epsvel);
fprintf('         nsteps: %i      (number of optimization searches)\n',md.nsteps);
fprintf('         optscal: (%i %i)      (scaling factor on gradient direction during optimization, for each optimization step)\n',size(md.optscal,1),size(md.optscal,2));
fprintf('         mincontrolconstraint: %f      (minimum contraint for the controlled parameters, NaN -> no constraint)\n',md.mincontrolconstraint);
fprintf('         maxcontrolconstraint: %f      (maximum contraint for the controlled parameters, NaN -> no constraint)\n',md.maxcontrolconstraint);
fprintf('         maxiter: (%i)      (maximum iterations during each optimization step)\n',length(md.maxiter));
fprintf('         tolx: %f      (minimum tolerance which will stop one optimization search)\n',md.tolx);
fprintf('         plot: %i      (visualization of the results of each iteration yes -> 1 no -> 0. Default is 1)\n',md.plot);

fprintf('\n      mesh:\n');
fprintf('         mesh_domainoutline: %s      (domain outlines)\n',md.mesh_domainoutline);
fprintf('         mesh_riftoutline: %s      (rift outlines)\n',md.mesh_riftoutline);
fprintf('         mesh_resolution: (%g)      (mesh resolutoin)\n',md.mesh_resolution);

%mesh2grid type
fprintf('\n      mesh2grid:\n');
mesh2grid_string='';
for i=1:length(md.mesh2grid_parameters),
	parameter=md.mesh2grid_parameters{i};
	mesh2grid_string=[mesh2grid_string parameter ' and '];
end
mesh2grid_string=mesh2grid_string(1:length(mesh2grid_string)-5);
fprintf('         mesh2grid_parameters: %s %s\n',mesh2grid_string,'(list of parameters for which mesh 2 grid interpolation is carried out; ex: {''drag''}, or {''drag'',''B''})');
%mesh2grid interpolation
mesh2grid_interpstring='';
for i=1:length(md.mesh2grid_interpolation),
	interpolation=md.mesh2grid_interpolation{i};
	mesh2grid_interpstring=[mesh2grid_interpstring interpolation ' and '];
end
mesh2grid_interpstring=mesh2grid_interpstring(1:length(mesh2grid_interpstring)-5);
fprintf('         mesh2grid_interpolation: %s %s\n',mesh2grid_interpstring,'(list of interpolation (''node'' or ''element'') for each parameter ex: {''node''}, or {''node'',''element''})');

%mesh2grid filter
mesh2grid_filterstring='';
for i=1:length(md.mesh2grid_filter),
	filter=md.mesh2grid_filter{i};
	mesh2grid_filterstring=[mesh2grid_filterstring filter ' and '];
end
mesh2grid_filterstring=mesh2grid_filterstring(1:length(mesh2grid_filterstring)-5);
fprintf('         mesh2grid_filter: %s %s\n',mesh2grid_filterstring,'(list of filter (''average'' or ''nearest'') for each parameter ex: {''average''}, or {''average'',''nearest''})');
fprintf('         mesh2grid_cornereast: %g ( corner east of square grid)\n',md.mesh2grid_cornereast);
fprintf('         mesh2grid_cornernorth: %g ( corner north of square grid)\n',md.mesh2grid_cornernorth);
fprintf('         mesh2grid_xposting: %g (x  posting of grid (in m))\n',md.mesh2grid_xposting);
fprintf('         mesh2grid_yposting: %g (y  posting of grid (in m))\n',md.mesh2grid_yposting);
fprintf('         mesh2grid_nlines: %g ( number of grid lines)\n',md.mesh2grid_nlines);
fprintf('         mesh2grid_ncolumns: %g ( number of grid columns)\n',md.mesh2grid_ncolumns);
fprintf('         mesh2grid_windowsize: %g ( size of filter )\n',md.mesh2grid_windowsize);

%parallelisation
md.parallel

%parameteroutput type
parameteroutput_string='';
for i=1:length(md.parameteroutput),
	parameter=md.parameteroutput{i};
	parameteroutput_string=[parameteroutput_string parameter ' and '];
end
parameteroutput_string=parameteroutput_string(1:length(parameteroutput_string)-5);

fprintf('\n      output:\n');
fprintf('         parameteroutput: %s %s\n',parameteroutput_string,...
                       '(list of output parameters recovered in the solution sequences: ex: {''viscousheating'',''stress''})\n');
