md=mesh(model,'../Exp/Pig.exp',30000);
md=geography(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,3,1);
md=setelementstype(md,'pattyn','all');
md.artificial_diffusivity=2;
md=SetParallel(md,3);
md=solve(md,'analysis_type',ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature1','MeltingRate1', ...
				      'Temperature2','MeltingRate2'};
field_tolerances={1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.ThermalSolution(1).Temperature),...
	PatchToVec(md.results.ThermalSolution(1).MeltingRate),...
	PatchToVec(md.results.ThermalSolution(2).Temperature),...
	PatchToVec(md.results.ThermalSolution(2).MeltingRate),...
	};
