/*
 * CreateElementsNodesAndMaterialsDiagnosticHoriz.c:
 */

#include "../../Container/Container.h"
#include "../../toolkits/toolkits.h"
#include "../../io/io.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "../../include/include.h"
#include "./ModelProcessorx.h"

void	CreateElementsVerticesAndMaterials(Elements** pelements,Vertices** pvertices,Materials** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle,const int nummodels){

	/*Intermediary*/
	int i,j,k,n;

	/*DataSets: */
	Elements*     elements  = NULL;
	Vertices*     vertices = NULL;
	Materials*    materials = NULL;

	/*Did we already create the elements? : */
	if(*pelements)return;

	/*First create the elements, vertices, nodes and material properties, if they don't already exist */
	elements  = new Elements(ElementsEnum);
	vertices  = new Vertices(VerticesEnum);
	materials = new Materials(MaterialsEnum);
	
	/*First, partition elements and vertices. Nodes will partitioned on a per analysis_type basis. If partitining already done, ignore: */
	ElementsAndVerticesPartitioning(&iomodel->my_elements,&iomodel->my_vertices,iomodel,iomodel_handle);
	
	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	IoModelFetchData(&iomodel->upperelements,NULL,NULL,iomodel_handle,"upperelements");
	IoModelFetchData(&iomodel->lowerelements,NULL,NULL,iomodel_handle,"lowerelements");
	IoModelFetchData(&iomodel->rheology_B,NULL,NULL,iomodel_handle,"rheology_B");
	IoModelFetchData(&iomodel->rheology_n,NULL,NULL,iomodel_handle,"rheology_n");
	IoModelFetchData(&iomodel->control_type,NULL,NULL,iomodel_handle,"control_type");
	
	/*Create elements and materials: */
	for (i=0;i<iomodel->numberofelements;i++){

		if(iomodel->my_elements[i]){

			/*Create and add tria element to elements dataset: */
			if(iomodel->dim==2)elements->AddObject(new Tria(i+1,i,iomodel,nummodels));
			else elements->AddObject(new Penta(i+1,i,iomodel,nummodels));

			/*Create and add material property to materials dataset: */
			materials->AddObject(new Matice(i+1,i,iomodel));
		}
	}
	
	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->upperelements);
	xfree((void**)&iomodel->lowerelements);
	xfree((void**)&iomodel->rheology_B);
	xfree((void**)&iomodel->rheology_n);
	xfree((void**)&iomodel->control_type);

	/*Add new constrant material property tgo materials, at the end: */
	materials->AddObject(new Matpar(iomodel->numberofelements+1,iomodel));//put it at the end of the materials
	
	/*Create vertices: */
	IoModelFetchData(&iomodel->x,NULL,NULL,iomodel_handle,"x");
	IoModelFetchData(&iomodel->y,NULL,NULL,iomodel_handle,"y");
	IoModelFetchData(&iomodel->z,NULL,NULL,iomodel_handle,"z");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->thickness_coeff,NULL,NULL,iomodel_handle,"thickness_coeff");
	
	for (i=0;i<iomodel->numberofvertices;i++){

		/*vertices and nodes (same number, as we are running continuous galerkin formulation: */
		if(iomodel->my_vertices[i]){
			
			/*Add vertex to vertices dataset: */
			vertices->AddObject(new Vertex(i+1,i,i,iomodel));
		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->x);
	xfree((void**)&iomodel->y);
	xfree((void**)&iomodel->z);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->thickness_coeff);

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pelements=elements;
	*pvertices=vertices;
	*pmaterials=materials;
}
