#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=$1;

#version of petsc?
#version='3.1-p7'
version='2.3.2-p3'; #default for now! (nightly runs)

#Some cleanup
rm -rf install petsc-$version src

#Create src and install directories
mkdir install src

#Untar 
tar -zxvf  petsc-$version.tar.gz

#Move petsc to install directory or src depending on the version
if [[ $version == "3.1-p7" ]]
then	
	mv petsc-$version/* src/
	rm -rf petsc-$version
	cd src
else
	mv petsc-$version/* install/
	rm -rf petsc-$version
	cd install
fi

#configure
../configure.sh

#Compile petsc and install it
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi
make install
