function PETSC_VERSION=petscversion()
%PETSCVERSION - recover petsc version number, inside config.h file
%
%   Usage:
%       PETSC_VERSION=petscversion();


configfile=[issmtier() '/config.h'];
if ~exist(configfile,'file'),
	error(['File ' configfile ' not found. ISSM has not been configured yet!']);
end

%go through the file, and recover the line we want
fid=fopen(configfile,'r');
while(1),
	tline=fgets(fid);
	if ~ischar(tline), break, end
	if length(tline)>=25,
		if  strcmpi(tline(1:23),'#define _PETSC_VERSION_'),
			PETSC_VERSION=str2num(tline(25));
		end
	end
end
fclose(fid);
