#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=$1;

#available versions
#2.3.2-p3
#3.0.0-p11

#version of petsc?
#version='3.1-p7'
version='2.3.2-p3'; #default for now! (nightly runs)

#Some cleanup
rm -rf install petsc-$version src

#Create src and install directories
mkdir install src

#Untar 
tar -zxvf  petsc-$version.tar.gz

#Move petsc to install directory
rm -rf src/*
mv petsc-$version/* src/
rm -rf petsc-$version

#Configure petsc
cd src
../configure.sh

#symlink some missing stuff.
if [[ $version == "3.0.0-p11" ]]
then	
	cd conf
	ln -s ../$ISSM_ARCH/conf/petscrules petscrules 
	ln -s ../$ISSM_ARCH/conf/petscvariables petscvariables 
	cd ../
	cd include
	ln -s ../$ISSM_ARCH/include/petscconf.h petscconf.h 
	cd ../
fi

#Compile petsc and install it
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi
make install
