function options=mumpsoptions(varargin)
%MUMPSOPTIONS - return MUMPS direct solver  petsc options
%
%   Usage:
%      options=mumpsoptions;

global PETSC_VERSION

%retrieve options provided in varargin
arguments=pairoptions(varargin{:});

%default mumps options
if PETSC_VERSION==2,
	options={{'mat_type','aijmumps'},{'ksp_type','preonly'},{'pc_type','lu'},{'mat_mumps_icntl_14',120},{'pc_factor_shift_positive_definite','true'}};
end
if PETSC_VERSION==3,
options={{'mat_type','mpidense'},{'ksp_type','preonly'},{'pc_type','lu'},{'mat_mumps_icntl_14',120},{'pc_factor_shift_positive_definite','true'}};
end

%now, go through our arguments, and write over default options.
for i=1:size(arguments.list,1),
	arg1=arguments.list{i,1};
	arg2=arguments.list{i,2};
	found=0;
	for j=1:size(options,2),
		joption=options{j};
		if strcmpi(joption{1},arg1),
			joption{2}=arg2;
			options{j}=joption;
			found=1;
			break;
		end
	end
	if ~found,
		%this option did not exist, add it: 
		options{end+1}={arg1,arg2};
	end
end
