function version=petscversion(issm_tier)
%PETSCVERSION: recover petsc version number, inside config.h file


fid=fopen([issm_tier '/config.h'],'r');

%go through the file, and recover the line we want
while(1),
	tline=fgets(fid);
	if ~ischar(tline), break, end
	if length(tline)>=25,
		if  strcmpi(tline(1:23),'#define _PETSC_VERSION_'),
			version=str2num(tline(25));
		end
	end
end
fclose(fid);
