function md=loadresultsfromdisk(md,filename)
%LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
%
%   Usage:
%      md=loadresultsfromdisk(md,filename);

%check number of inputs/outputs
if ((nargin~=2) | (nargout~=1)),
	help loadresultsfromdisk;
	error('loadresultsfromdisk: error message.');
end

%load result onto model
eval(['md.results.' md.analysis_type '=parseresultsfromdisk(filename);']);

%Check result is consistent
disp(sprintf('%s\n','checking result consistency'));
if ~isresultconsistent(md,md.analysis_type),
	%it would be very cruel to put an error, it would kill the computed results (even if not consistent...)
	disp('!! results not consistent correct the model !!') 
end
