function results=parseresultsfromdisk(filename)
%PARSERESULTSFROMDISKIOSPLIT - ...
%
%   Usage:
%      results=parseresultsfromdiskiosplit(filename)


%Open file
fid=fopen(filename,'rb');
if(fid==-1),
	error(['loadresultsfromdisk error message: could not open ',filename,' for binary reading']);
end
results=struct();

%if we have done split I/O, ie, we have results that are fragmented across patches, 
%do a first pass, and figure out the structure of results
result=ReadDataDimensions(fid);
while ~isempty(result),

	%Get time and step
	results(result.step).step=result.step;
	results(result.step).time=result.time; 

	%Add result
	if strcmpi(result.fieldname,'Patch'),
		results(result.step).(result.fieldname)=[0 result.N];
	else
		results(result.step).(result.fieldname)=NaN;
	end

	%read next result
	result=ReadDataDimensions(fid);
end

%do a second pass, and figure out the size of the patches
fseek(fid,0,-1); %rewind
result=ReadDataDimensions(fid);
while ~isempty(result),

	%Add result
	if strcmpi(result.fieldname,'Patch'),
		patchdimensions=results(result.step).(result.fieldname);
		results(result.step).(result.fieldname)=[patchdimensions(1)+result.M result.N];
	end

	%read next result
	result=ReadDataDimensions(fid);
end

%allocate patches
for i=1:length(results),
	results(i).Patch=zeros(results(i).Patch(1),results(i).Patch(2));
	results(i).counter=1; %use to index into the patch
end

%third pass, this time to read the real information
fseek(fid,0,-1); %rewind
result=ReadData(fid);
while ~isempty(result),

	%Get time and step
	results(result.step).step=result.step;
	results(result.step).time=result.time; 

	%Add result
	if strcmpi(result.fieldname,'Patch'),
		counter=results(result.step).counter;
		counter2=counter+size(result.field,1)-1;
		results(result.step).(result.fieldname)(counter:counter2,:)=result.field;

		%increment counter: 
		results(result.step).counter=counter2+1;
	else
		results(result.step).(result.fieldname)=result.field;
	end

	%read next result
	result=ReadData(fid);

end

%close file
fclose(fid);
