function results=parseresultsfromdiskioserial(filename)
%PARSERESULTSFROMDISK - ...
%
%   Usage:
%      results=parseresultsfromdiskioserial(filename)


%Open file
fid=fopen(filename,'rb');
if(fid==-1),
	error(['loadresultsfromdisk error message: could not open ',filename,' for binary reading']);
end
results=struct();

%Read fields until the end of the file.
result=ReadData(fid);
while ~isempty(result), 
	%Get time and step
	results(result.step).step=result.step;
	results(result.step).time=result.time; 

	%Add result
	if (length(results)>=result.step & isfield(results,result.fieldname) & ~strcmp(result.fieldname,'SolutionType')),
			results(result.step).(result.fieldname)=[ results(result.step).(result.fieldname); result.field];
	else
		results(result.step).(result.fieldname)=result.field;
	end

	%read next result
	result=ReadData(fid);

end

fclose(fid);
