#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#version of valgrind
version=`echo *.tar.bz2 | sed 's/\.tar\.bz2//g' | sed 's/valgrind-//g'`
echo $version

#Some cleanup
rm -rf install valgrind-$version

#Create install directories
mkdir install

#Untar 
#tar -zxvf  valgrind-$version.tar.gz
tar -jxvf  valgrind-$version.tar.bz2

#Move valgrind into install directory
mv valgrind-$version/* install
rm -rf valgrind-$version

cd install

#configure
../configure.sh

#Compile valgrind
make  -j $NUMCPUS

make install

#final thing: if mpi is compiled in, soft link its target to a simpler name
cd lib
ln -s valgrind/libmpi*  ./libmpidebug.so

