/*!\file: prognostic_core.cpp
 * \brief: core of the prognostic solution 
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "prognostic_core"

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./parallel.h"
#include "../issm.h"

void prognostic_core(DataSet* results,FemModel* fem, ParameterInputs* inputs){

	extern int my_rank;

	/*output: */
	Result* result=NULL;

	/*intermediary: */
	Vec u_g=NULL;

	/*solutions: */
	Vec h_g=NULL;

	/*flags: */
	int debug=0;
	int numberofdofspernode;
	int numberofnodes;
	int dofs[2]={1,1};

	//first recover parameters common to all solutions
	fem->parameters->FindParam((void*)&debug,"debug");
	fem->parameters->FindParam((void*)&numberofnodes,"numberofnodes");
	fem->parameters->FindParam((void*)&numberofdofspernode,"numberofdofspernode");

	_printf_("depth averaging velocity...");
	u_g=inputs->Get("velocity",&dofs[0],2); //take (vx,vy) from inputs velocity
	VelocityDepthAveragex( u_g, fem->elements,fem->nodes, fem->loads, fem->materials);
	inputs->Add("velocity_average",u_g,2,numberofnodes);
	
	_printf_("call computational core:\n");
	diagnostic_core_linear(&h_g,fem,inputs,PrognosticAnalysisEnum(),NoneAnalysisEnum());

	_printf_("extrude computed thickness on all layers:\n");
	ThicknessExtrudex( h_g, fem->elements,fem->nodes, fem->loads, fem->materials);

	/*Plug results into output dataset: */
	result=new Result(results->Size()+1,0,1,"h_g",h_g);
	results->AddObject(result);
}
