/*!\file:  OutputControl.cpp
 * \brief: output control results
 */ 

#include "./parallel.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../objects/objects.h"

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__ "OutputControl"

void OutputControl(Vec u_g,double* p_g,double* J,int nsteps,FemModel* fem,char* outputfilename){

	/*intermediary: */
	DataSet* results=NULL;
	Result*  result=NULL;
	int numberofnodes;

	/*recover numberofnodes: */
	fem->parameters->FindParam((void*)&numberofnodes,"numberofnodes");

	results=new DataSet(ResultsEnum());

	/*Plug results into output dataset: */
	result=new Result(results->Size()+1,0,1,"u_g",u_g);
	results->AddObject(result);

	result=new Result(results->Size()+1,0,1,"p_g",p_g,numberofnodes);
	results->AddObject(result);

	result=new Result(results->Size()+1,0,1,"J",J,nsteps);
	results->AddObject(result);

	//process results
	ProcessResults(&results,fem,ControlAnalysisEnum());
	
	//write results to disk:
	OutputResults(results,outputfilename);

	/*Free ressources:*/
	delete results;

}

