/*\file Response.c
 *\brief: compute misfit between modeled velocity and observed velocity
 */

#include "./Response.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements   *elements   = NULL;
	Loads      *loads      = NULL;
	Nodes      *nodes      = NULL;
	Vertices   *vertices   = NULL;
	Materials  *materials  = NULL;
	Parameters *parameters = NULL;
	char       *response   = NULL;
	bool        process_units;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ResponseUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&response,RESPONSE);
	FetchData(&process_units,PROCESSUNITS);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*for MassFlux, loop over all profiles: */
	if (StringToEnum(response) == MassFluxEnum) {
		int  counter;

		/*all segments: */
		double** array=NULL;
		int      M;

		/* output datasets: */
		double*  resp;

		/*First, figure out which segment to compute our mass flux on. Start with retrieving qmu_mass_flux_segments: */
		if(!parameters->FindParam(&array,&M,NULL,NULL,QmuMassFluxSegmentsEnum))_error_(" could not find QmuMassFluxSegmentsEnum");

		/*Retrieve index of segments being used for MassFlux computation: */
//		if(!parameters->FindParam(&counter,IndexEnum))_error_(" could not find IndexEnum");

		resp=(double*)xcalloc(M,sizeof(double));
		for (counter=0; counter<M; counter++) {
			/*indexed response: plug index into parameters and call response module: */
			parameters->SetParam(counter+1,IndexEnum);

			/*!Call core code: */
			Responsex(&resp[counter], elements,nodes,vertices, loads,materials,parameters,response,process_units);
		}

		/*write output : */
		WriteData(OUTPUT,resp,M);
//		WriteData does not copy data, so don't free (jes, 11/30/10)
//		xfree((void**)&resp);
	}

	/*otherwise a single call: */
	else {
		/* output datasets: */
		double   resp;

		/*!Call core code: */
		Responsex(&resp, elements,nodes,vertices, loads,materials,parameters,response,process_units);

		/*write output : */
		WriteData(OUTPUT,resp);
	}

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	xfree((void**)&response);

	/*end module: */
	MODULEEND();
}

void ResponseUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [resp] = %s(elements,nodes,vertices,loads,materials,parameters,response,process_units);\n",__FUNCT__);
	_printf_(true,"\n");
	_printf_(true,"      response:      string ('MinVel', 'MassFlux', 'MaxAbsVx',...)\n");
	_printf_(true,"      process_units: bolean\n");
	_printf_(true,"\n");
}
