function md=qmuin(md,package,varargin)
%INPUT function md=qmuin(md,package,varargin)
%Create dakota input file for parallel runs

global ISSM_DIR;

% qmudir =['qmu_' datestr(now,'yyyymmdd_HHMMSS')];
qmudir ='qmu';
%  qmufile can not be changed unless cielo_ice_script.sh is also changed
qmufile=md.name;
ivar   =1;
iresp  =1;
imethod=1;
iparams=1;
runmpi =false;

%  process any extra input arguments

for i=1:2:nargin-2
    switch varargin{i}
        case 'qmudir'
            qmudir =varargin{i+1};
            disp(sprintf('qmudir =%s',qmudir));
        case 'qmufile'
            qmufile=varargin{i+1};
            disp(sprintf('qmufile=%s',qmufile));
        case 'ivar'
            ivar   =varargin{i+1};
            disp(sprintf('ivar   =%d',ivara));
        case 'iresp'
            iresp  =varargin{i+1};
            disp(sprintf('iresp  =%d',iresp));
        case 'imethod'
            imethod=varargin{i+1};
            disp(sprintf('imethod=%d',imethod));
        case 'iparams'
            iparams=varargin{i+1};
            disp(sprintf('iparams=%d',iparams));
        case 'overwrite'
            overwrite=varargin{i+1};
            disp(sprintf('overwrite=%s',overwrite));
        case 'outfiles'
            outfiles =varargin{i+1};
            disp(sprintf('outfiles =%s',outfiles));
        case 'rstfile'
            rstfile  =varargin{i+1};
            disp(sprintf('rstfile  =%s',rstfile));
        case 'rundakota'
            rundakota=varargin{i+1};
            disp(sprintf('rundakota=%s',rundakota));
        case 'runmpi'
            runmpi =varargin{i+1};
            disp(sprintf('runmpi =%d',runmpi));
    end
end

if exist(qmudir,'dir')
    if ~exist('overwrite','var')
        overwrite=input(['Overwrite existing ''' qmudir ''' directory? Y/N [N]: '], 's');
    end
    if strncmpi(overwrite,'y',1)
        system(['rm -rf ' qmudir]);
%    else
%        error('Existing ''%s'' directory not overwritten.',qmudir);
    end
end
mkdir(qmudir)
cd(qmudir)

%create m and in files for dakota
if (~isfield(md.qmu_params(iparams),'direct') || ...
    ~md.qmu_params(iparams).direct) && ...
   (~isfield(md.qmu_params(iparams),'analysis_driver') || ...
    isempty(md.qmu_params(iparams).analysis_driver))
    md.qmu_params(iparams).analysis_driver=[ISSM_DIR '/src/m/solutions/dakota/cielo_ice_script.sh'];
end

dakota_in_data(md.qmu_method(imethod),md.variables(ivar),md.responses(iresp),md.qmu_params(iparams),qmufile,package,md);


system(['rm -rf ' md.name '.m']);
cd ../

%keep iresp for response function handling in marshall routine.
md.iresp=iresp;
