#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=$1;
version='3.8.1'

#Create install directories
mkdir install

#Untar 
tar -zxvf  Paraview-$version.tar.gz

#Move Paraview to install directory
rm -rf install/*
mv Paraview-$version/* install/
rm -rf Paraview-$version

#Configure Paraview
cd install
../configure.sh

#Compile Paraview and install it
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi
make install
