/*!\file: solver_linear.cpp
 * \brief: numerical core of linear solutions
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"

void solver_linear(FemModel* femmodel){

	/*intermediary: */
	Mat  Kgg = NULL, Kff = NULL, Kfs   = NULL;
	Vec  ug  = NULL, uf  = NULL;
	Vec  pg  = NULL, pf  = NULL;
	bool kffpartitioning;

	/*Recover parameters: */
	femmodel->parameters->FindParam(&kffpartitioning,KffEnum);

	if(kffpartitioning){
		SystemMatricesx(NULL,&Kff, &Kfs, NULL,&pf, NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
		Reduceloadx(pf, Kfs, femmodel->ys); MatFree(&Kfs);
	}
	else{
		SystemMatricesx(&Kgg, NULL, NULL, &pg,NULL, NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
		Reducematrixfromgtofx(&Kff,&Kfs,Kgg,femmodel->nodesets); MatFree(&Kgg);
		Reduceloadfromgtofx(&pf, pg, Kfs, femmodel->ys, femmodel->nodesets);VecFree(&pg); MatFree(&Kfs);
	}

	Solverx(&uf, Kff, pf, NULL, femmodel->parameters); MatFree(&Kff); VecFree(&pf);
	Mergesolutionfromftogx(&ug, uf,femmodel->ys,femmodel->nodesets);VecFree(&uf);
	InputUpdateFromSolutionx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,ug); VecFree(&ug); VecFree(&uf);
}
