/*!\file Mergesolutionfromftogx
 * \brief merge solution back from f set into g set
 */

#include "./Mergesolutionfromftogx.h"

void	Mergesolutionfromftogx( Vec* pug, Vec uf, Vec ys, NodeSets* nodesets,bool flag_ys0){

	/*output: */
	Vec ug=NULL;
	Vec ys0=NULL;
	int ug_local_size;
	
	/*Display message*/
	_printf_(VerboseModule(),"   Merging solution vector from fset to gset\n");

	/*Merge f set back into g set: */
	ug=NewVec(nodesets->GetGSize());
	if(uf) VecMerge(ug,uf,nodesets->GetPV_F(),nodesets->GetFSize());

	/*merge single point constraints into g set: */
	if(ys){
		if (flag_ys0){

			/*Create ys0, full of 0: */
			VecDuplicate(ys,&ys0);
			VecSet(ys0,0.0);
			VecAssemblyBegin(ys0);
			VecAssemblyEnd(ys0);

			VecMerge(ug,ys0,nodesets->GetPV_S(),nodesets->GetSSize());
		}
		else{
			VecMerge(ug,ys,nodesets->GetPV_S(),nodesets->GetSSize());
		}
	}

	/*Free ressources:*/
	VecFree(&ys0);

	/*Assign correct pointer*/
	*pug=ug;
}
