/*!\file: solver_adjoint_linear.cpp
 * \brief: numerical core of linear solutions
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"

void solver_adjoint_linear(FemModel* femmodel){
	/*This is axactly the same solver as solver_linear except that Reduceloadfromgtofx and Mergesolutionfromftogx
	 * use the flag "true" so that all spc are taken as 0*/

	/*intermediary: */
	Mat  Kgg = NULL, Kff = NULL, Kfs = NULL;
	Vec  ug  = NULL, uf  = NULL;
	Vec  pg  = NULL, pf  = NULL;
	bool kffpartitioning = false;

	/*Recover parameters: */
	femmodel->parameters->FindParam(&kffpartitioning,KffEnum);

	if(kffpartitioning){
		SystemMatricesx(NULL,&Kff, &Kfs, NULL,&pf, NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
		Reduceloadx(pf, Kfs, femmodel->ys,true); MatFree(&Kfs); //true means spc = 0
	}
	else{
		SystemMatricesx(&Kgg, NULL, NULL, &pg,NULL, NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
		Reducematrixfromgtofx(&Kff,&Kfs,Kgg,femmodel->nodesets); MatFree(&Kgg);
		Reduceloadfromgtofx(&pf, pg, Kfs, femmodel->ys, femmodel->nodesets,true);VecFree(&pg); MatFree(&Kfs);//true means spc = 0
	}

	Solverx(&uf, Kff, pf, NULL, femmodel->parameters); MatFree(&Kff); VecFree(&pf);
	Mergesolutionfromftogx(&ug, uf,femmodel->ys,femmodel->nodesets,true); VecFree(&uf);//true means spc0
	InputUpdateFromSolutionx(femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,ug); VecFree(&ug); VecFree(&uf);
}
