/* \file AnalysisTypeAsEnum.cpp
 * \brief get integer enum instead of a string
 */

#include "./EnumDefinitions.h"
#include "../shared/shared.h"

#undef __FUNCT__ 
#define __FUNCT__ "AnalysisTypeAsEnum"

int AnalysisTypeAsEnum(char* analysis_type){

	if (analysis_type==NULL){
		throw ErrorException(__FUNCT__," analysis_type is NULL");
	}

	if (strcmp(analysis_type,"diagnostic")==0){
		return DiagnosticAnalysisEnum();
	}
	else if (strcmp(analysis_type,"control")==0){
		return ControlAnalysisEnum();
	}
	else if (strcmp(analysis_type,"thermal")==0){
		return ThermalAnalysisEnum();
	}
	else if (strcmp(analysis_type,"prognostic")==0){
		return PrognosticAnalysisEnum();
	}
	else if (strcmp(analysis_type,"melting")==0){
		return MeltingAnalysisEnum();
	}
	else if (strcmp(analysis_type,"slope_compute")==0){
		return SlopeComputeAnalysisEnum();
	}
	else if (strcmp(analysis_type,"stokes")==0){
		return StokesAnalysisEnum();
	}
	else if (strcmp(analysis_type,"hutter")==0){
		return HutterAnalysisEnum();
	}
	else if (strcmp(analysis_type,"surfacex")==0){
		return SurfaceXAnalysisEnum();
	}
	else if (strcmp(analysis_type,"surfacey")==0){
		return SurfaceYAnalysisEnum();
	}
	else if (strcmp(analysis_type,"bedx")==0){
		return BedXAnalysisEnum();
	}
	else if (strcmp(analysis_type,"bedy")==0){
		return BedYAnalysisEnum();
	}
	else if (strcmp(analysis_type,"horiz")==0){
		return HorizAnalysisEnum();
	}
	else if (strcmp(analysis_type,"vert")==0){
		return VertAnalysisEnum();
	}
	else if (strcmp(analysis_type,"steady")==0){
		return SteadyAnalysisEnum();
	}
	else if (strcmp(analysis_type,"transient")==0){
		return TransientAnalysisEnum();
	}
	else if (strcmp(analysis_type,"none")==0){
		return NoneAnalysisEnum();
	}
	else if (strcmp(analysis_type,"")==0){
		return NoneAnalysisEnum();
	}
	else throw ErrorException(__FUNCT__,exprintf("%s%s"," could not recognize analysis type: ",analysis_type));

}


