/*\file Reducematrixfromgtof.c
 *\brief: reduce matrix from g set to f set.
 */

#include "./Reducematrixfromgtof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Mat         Kgg        = NULL;
	NodeSets   *nodesets   = NULL;

	/* output datasets: */
	Mat Kff = NULL;
	Mat Kfs = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ReducematrixfromgtofUsage);

	/*Input datasets: */
	FetchData(&Kgg,KGG);
	FetchNodeSets(&nodesets,NODESETS);

	/*!Reduce matrix from g to f size:*/
	Reducematrixfromgtofx(&Kff,&Kfs,Kgg,nodesets);

	/*write output datasets: */
	WriteData(KFF,Kff);
	WriteData(KFS,Kfs);

	/*Free ressources: */
	delete nodesets;
	MatFree(&Kgg);
	MatFree(&Kff);
	MatFree(&Kfs);

	/*end module: */
	MODULEEND();
}

void ReducematrixfromgtofUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [Kff,Kfs] = %s(Kgg,nodesets);\n",__FUNCT__);
	_printf_(true,"\n");
}
