function outoptions=process_solve_options(options)
%DEFAULT_SOLVE_OPTIONS - set up default options for solve phase
%
%   Usage:
%      options=process_solve_options(options)
%
%   See also: SOLVE

%analysis_type: check on this option, error out otherwise
analysis_type=getfieldvalue(options,'analysis_type');

%sub_analysis_type: check on it, not mandatory
sub_analysis_type=getfieldvalue(options,'sub_analysis_type',NoneAnalysisEnum);

%batch mode for launching jobs.
outoptions.batch=getfieldvalue(options,'batch','no');

%directory 
outoptions.directory=getfieldvalue(options,'directory','');

%convert to Enum if a string was provided
if ischar(analysis_type), error(['only Enums are supported as ''analysis_type''. For example: md=solve(md,''analysis_type'',DiagnosticSolutionEnum); ']); end
if ischar(sub_analysis_type), error(['only Enums are supported as ''sub_analysis_type''. For example: md=solve(md,''analysis_type'',DiagnosticSolutionEnum); ']); end

%check solution type is supported
if ~ismember(analysis_type,[DiagnosticSolutionEnum,PrognosticSolutionEnum,ThermalSolutionEnum,...
		SteadystateSolutionEnum,ParametersSolutionEnum,Transient2DSolutionEnum,Transient3DSolutionEnum...
		BalancedthicknessSolutionEnum,BalancedvelocitiesSolutionEnum,BedSlopeSolutionEnum,SurfaceSlopeSolutionEnum]),
	error(['process_solve_options error message: analysis_type ' EnumToString(analysis_type) ' not supported yet!']);
end
if ~ismember(sub_analysis_type,[SteadyAnalysisEnum,NoneAnalysisEnum,GradientAnalysisEnum,InverseAnalysisEnum,TransientAnalysisEnum]),
	error(['process_solve_options error message: sub_analysis_type ' sub_analysis_type ' not supported yet!']);
end
outoptions.analysis_type=analysis_type;
outoptions.sub_analysis_type=sub_analysis_type;
outoptions.upload=getfieldvalue(options,'upload','off');

%  process qmu arguments
outoptions.qmudir=getfieldvalue(options,'qmudir',['qmu' num2str(GetPId)]);  % qmudir =['qmu_' datestr(now,'yyyymmdd_HHMMSS')];
outoptions.qmufile=getfieldvalue(options,'qmufile','qmu');% qmufile cannot be changed unless ????script.sh is also changed
outoptions.overwrite=getfieldvalue(options,'overwrite','n');
outoptions.keep=getfieldvalue(options,'keep','n');
outoptions.ivar=getfieldvalue(options,'ivar',1);
outoptions.iresp=getfieldvalue(options,'iresp',1);
outoptions.imethod=getfieldvalue(options,'imethod',1);
outoptions.iparams=getfieldvalue(options,'iparams',1);
outoptions.runmpi=getfieldvalue(options,'runmpi',false);
