function plot_overlay(md,data,options,plotlines,plotcols,i)
%PLOT_OVERLAY - superimpose radar image to a given field
%
%   Usage:
%      plot_overlay(md,options,plotlines,plotcols,i)
%
%   See also: PLOTMODEL

%process mesh and data
[x y z elements is2d]=processmesh(md,[],options);
[data datatype]=processdata(md,data,options);

%check is2d
if ~is2d, 
	error('buildoverlay error message: overlay not supported for 3d meshes, project on a layer');
end
if datatype==3,
	error('buildoverlay error message: overlay not supported for quiver plots');
end

%Get xlim and ylim (used to extract radar image)
xlim=getfieldvalue(options,'xlim',[min(x) max(x)]);
ylim=getfieldvalue(options,'ylim',[min(y) max(y)]);
xlim2=xlim/getfieldvalue(options,'unit',1);
ylim2=ylim/getfieldvalue(options,'unit',1);

%radar power {{{1
if ~any(isnan(md.sarxm)) & ~any(isnan(md.sarym)) & ~any(isnan(md.sarpwr)),
	disp('plot_overlay info: the radar image held by the model is being used');
else
	disp('Extracting radar image...');
	md=radarpower(md,xlim2,ylim2,getfieldvalue(options,'highres',0));
end%}}}
%InterpFromMeshToGrid{{{1
cornereast =min(xlim);
cornernorth=max(ylim);
xspacing=(max(xlim)-min(xlim))/(length(md.sarxm));
yspacing=(max(ylim)-min(ylim))/(length(md.sarym));
nlines=length(md.sarym);
ncols =length(md.sarxm);
disp('Interpolating data on grid...');
[x_m y_m data_grid]=InterpFromMeshToGrid(elements,x,y,data,cornereast,cornernorth,xspacing,yspacing,nlines,ncols,NaN);

%Process data_grid
if exist(options,'caxis'),
	caxis_opt=getfieldvalue(options,'caxis');
	data_grid(find(data_grid<caxis_opt(1)))=caxis_opt(1);
	data_grid(find(data_grid>caxis_opt(2)))=caxis_opt(2);
	data_min=caxis_opt(1);
	data_max=caxis_opt(2);
else
	data_min=min(data_grid(:));
	data_max=max(data_grid(:));
end
data_nan=find(isnan(data_grid));

%}}}
%Generate HSV image{{{1

%options
contrast=getfieldvalue(options,'contrast',1);  
transparency=getfieldvalue(options,'alpha',1.5);  %Rignot's setting: 1.5
data_coba=linspace(data_min,data_max,256);        %prepare colorbar (256 values between min and max)
data_grid(data_nan)=data_min; 

%hue (H)
h_data=bytscl(data_grid)/(255+1);           %scale between 0 and 1 (log applied in processdata)
h_coba=bytscl(data_coba)/(255+1);           %scale between 0 and 1
%saturation (S)
s_data=(0.5+10.^data_grid/125)/transparency;s_data(find(s_data>1))=1;s_data(find(s_data<0))=0;
s_coba=(0.5+10.^data_coba/125)/transparency;s_coba(find(s_coba>1))=1;s_coba(find(s_coba<0))=0;
s_data(data_nan)=0;
%intensity (V)
radar=(md.sarpwr).^(contrast);
v_data=radar/max(radar(:)); %For the principla image, use radar power as intensity
v_coba=ones(256,1);         %For the colorbar: maximal intensity

%}}}
%Transform HSV to RGB {{{1
image_hsv=zeros(size(data_grid,1),size(data_grid,2),3);
image_hsv(:,:,1)=h_data;
image_hsv(:,:,2)=s_data;
image_hsv(:,:,3)=v_data;
image_rgb=hsv2rgb(image_hsv);
colorbar_hsv=zeros(size(data_coba,2),size(data_coba,1),3);
colorbar_hsv(:,:,1)=h_coba;
colorbar_hsv(:,:,2)=s_coba;
colorbar_hsv(:,:,3)=v_coba;
colorbar_rgb=hsv2rgb(colorbar_hsv);
%}}}

%Select plot area 
subplot(plotlines,plotcols,i);
%uncomment following lines to have more space
%P=get(gca,'pos');
%P(3)=P(3)+0.05;
%P(2)=P(2)+0.08;
%P(1)=P(1)-0.02;
%set(gca,'pos',P);

%Plot: 
imagesc(md.sarxm*getfieldvalue(options,'unit',1),md.sarym*getfieldvalue(options,'unit',1),image_rgb);set(gca,'YDir','normal');

%last step: mesh overlay?
if exist(options,'edgecolor'),
	A=elements(:,1); B=elements(:,2); C=elements(:,3); 
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor',getfieldvalue(options,'edgecolor'));
end

%Apply options, without colorbar and without grid
options=changefieldvalue(options,'colormap','hsv');            %We used an HSV colorbar
options=changefieldvalue(options,'caxis',[data_min data_max]); %force caxis so that the colorbar is ready
options=addfielddefault(options,'axis','equal off');           %default axis
applyoptions(md,data,options);
