function u_g=VelocityExtrude(md,u_g);
%VELOCITYEXTRUDE - extrude the velocity
%
%   Extrude collapsed horizontal velocities present in MacAyeal elements
%
%   Usage:
%      u_g=VelocityExtrude(md,u_g)

if strcmpi(md.type,'2d'),
	%do nothing, we don't have a 3d mesh anyway.
else

	%Find list of 2d grids that belong to the collapsed macayeal elements.
	%And remove grids on the border.
	%These grids are on macayeal but not on pattyn nor hutter nor dirichlet
	grids2d=md.gridonmacayeal(1:md.numberofgrids2d);%  & ~(md.gridonhutter(1:md.numberofgrids2d) | md.gridonpattyn(1:md.numberofgrids2d) | md.gridondirichlet_diag(1:md.numberofgrids2d));
	
	vx2d=u_g(1:6:6*md.numberofgrids2d).*grids2d;
	vy2d=u_g(2:6:6*md.numberofgrids2d).*grids2d;

	%Extrude across the 3d mesh
	vx3d=project3d(md,vx2d,'node')+u_g(1:6:end).*double(~md.gridonmacayeal);
	vy3d=project3d(md,vy2d,'node')+u_g(2:6:end).*double(~md.gridonmacayeal);

	%Plug back into u_g
	u_g(1:6:end)=vx3d;
	u_g(2:6:end)=vy3d;

end

end %end function
