function md=radarpower(md,xlim,ylim,highres)
%RADARPOWER - overlay a power radar image on an existing mesh
%
%   This routine will overlay a power radar image on an existing mesh.
%   The power amplitude will be output to vel for now.
%   In the future, think about a field to hold this value.
%
%   Usage:
%      md=radarpower(md,xlim,ylim,highres)
%      md=radarpower(md,xlim,ylim)
%      md=radarpower(md)

global ISSM_TIER
global MODELDATA

%if MODELDATA has not been initialized (ie: empty), use default path.
if isempty(MODELDATA), MODELDATA='/u/astrid-r1b/larour/ModelData'; end

%Parse inputs
if nargin<4,
	highres=0;
end
if nargin<3,
	xlim=[min(md.x) max(md.x)];
	ylim=[min(md.y) max(md.y)];
end

%find gdal coordinates
x0=min(xlim); x1=max(xlim);
y0=min(ylim); y1=max(ylim);

%the geotiff image is either 200m or 1km accuracy. 
if strcmpi(md.hemisphere,'n'),
	if ~exist([MODELDATA '/MOG/mog150_greenland_map.jpg']),
		error(['radarpower error message: file ' MODELDATA '/MOG/mog150_greenland_map.jpg not found. Check MODELDATA variable..']);
	end
	jpgim=[MODELDATA '/MOG/mog150_greenland_map.jpg'];
	geom=load([MODELDATA '/MOG/mog150_greenland_map.jpgw'],'ascii');
	sizex=floor((x1-x0)/geom(1)); % x posting
	sizey=floor((y1-y0)/geom(4)); % y posting
	topleftx=floor((x0-geom(5))/geom(1)); % x min
	toplefty=floor((geom(6)-y1)/geom(4)); % y max

	%Read and crop file
	disp('Warning: expecting coordinates in polar stereographic (Std Latitude: 70ºN Meridian: 45º)');
	im=imread(jpgim);
	im=im(toplefty:toplefty+sizey,topleftx:topleftx+sizex);
	md.sarpwr=double(flipud(im));
	md.sarxm=(x0:(x1-x0)/(size(md.sarpwr,2)-1):x1);
	md.sarym=(y0:(y1-y0)/(size(md.sarpwr,1)-1):y1);

elseif strcmpi(md.hemisphere,'s'),
	if highres,
		if ~exist([MODELDATA '/MosaicTiffRsat/amm125m_v2_200m.tif']),
			error(['radarpower error message: file ' MODELDATA '/MosaicTiffRsat/amm125m_v2_200m.tif not found. Check MODELDATA variable..']);
		end
		geotiff_name=[MODELDATA '/MosaicTiffRsat/amm125m_v2_200m.tif'];
	else
		if ~exist([MODELDATA '/MosaicTiffRsat/amm125m_v2_1km.tif']),
			error(['radarpower error message: file ' MODELDATA '/MosaicTiffRsat/amm125m_v2_1km.tif not found. Check MODELDATA variable..']);
		end
		geotiff_name=[MODELDATA '/MosaicTiffRsat/amm125m_v2_1km.tif'];
	end

	%Name of image
	inputname='./temp.tif';
	eval(['!gdal_translate -quiet -projwin ' num2str(x0) ' ' num2str(y1) ' ' num2str(x1) ' ' num2str(y0) ' ' geotiff_name ' ' inputname ]);

	%Read in temp.tif:
	md.sarpwr=double(flipud(imread('temp.tif','TIFF')));
	md.sarxm=(x0:(x1-x0)/(size(md.sarpwr,2)-1):x1);
	md.sarym=(y0:(y1-y0)/(size(md.sarpwr,1)-1):y1);

	%Erase image
	system('rm -rf ./temp.tif');

else
	error('field hemisphere should either be ''n'' or ''s''');
end
