%
%  definition for the kml_placemark sub (derived) class.
%
%  [kml]=kml_placemark(varargin)
%
%  where the optional varargin and defaults are:
%    id            (char, placemark id, '')
%    name          (char, name, '')
%    visibility    (logical, visibility, true)
%    open          (logical, open, false)
%    snippet       (char, snippet, '')
%    descript      (char, description, '')
%    styleurl      (char, style url, '')
%    style         (cell array, styles)
%    geometry      (kml_geometry, placemark geometry)
%
%  note that zero arguments constructs a default instance; one
%  argument of the class copies the instance; and two or more
%  arguments constructs a new instance from the arguments.
%
classdef kml_placemark < kml_feature
    properties
        geometry  =kml_geometry.empty();
    end
    
    methods
        function [kml]=kml_placemark(varargin)

            kml=kml@kml_feature(varargin{:});

            switch nargin

%  create a default object

                case 0

%  copy the object or create the object from the input

                otherwise
                    if (nargin == 1) && isa(varargin{1},class(kml))
                        kml=varargin{1};

                    else
                        fnames=fieldnames(kml);

                        for i=length(fieldnames(kml_feature()))+1:min(nargin,length(fnames))
                            if isa(varargin{i},class(kml.(fnames{i})))
                                if ~isempty(varargin{i})
                                    kml.(fnames{i})=varargin{i};
                                end
                            else
                                if ~isempty(inputname(i))
                                    warning('Argument ''%s'' for property ''%s'' is a ''%s'' class object, not ''%s''.',...
                                        inputname(i),fnames{i},class(varargin{i}),class(kml.(fnames{i})));
                                else
                                    warning('Argument %d for property ''%s'' is a ''%s'' class object, not ''%s''.',...
                                        i           ,fnames{i},class(varargin{i}),class(kml.(fnames{i})));
                                end
                            end
                        end
                    end

            end

        end

%  display the object

        function []=disp(kml)

            for i=1:numel(kml)
                disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
                    class(kml),inputname(1),string_dim(kml,i)));
                disp@kml_feature(kml(i));
                disp(sprintf('      geometry: %s %s\n' ,string_size(kml(i).geometry),...
                             class(kml(i).geometry)));
            end

        end

%  return the fieldnames of the object

        function [fnames]=fieldnames(kml)

%  fieldnames for a sub (derived) class list those before super (base)

            fnames=fieldnames(kml_feature());
            fnames={fnames{:} ...
                    'geometry' ...
                   }';

        end

%  set the properties of the object

        function [kml]=set(kml,varargin)

            kmlref=feval(class(kml));
            fnames=fieldnames(kmlref);

%  loop through each parameter in the input list (comparing to the reference
%  object in case property types have been changed)

            for i=1:2:length(varargin)
                if ismember(varargin{i},fnames) && (i+1 <= length(varargin))
                    if isa(varargin{i+1},class(kmlref.(varargin{i})))
                        kml.(varargin{i})=varargin{i+1};
                    else
                        if ~isempty(inputname(i+1))
                            warning('Argument ''%s'' for property ''%s'' is a ''%s'' class object, not ''%s''.',...
                                inputname(i+2),varargin{i},class(varargin{i+1}),class(kmlref.(varargin{i})));
                        else
                            warning('Argument %d for property ''%s'' is a ''%s'' class object, not ''%s''.',...
                                i+2           ,varargin{i},class(varargin{i+1}),class(kmlref.(varargin{i})));
                        end
                    end
                else
                    warning('Property ''%s'' for class ''%s'' does not exist.',...
                        varargin{i},class(kmlref));
                end
            end

        end

%  write the object

        function []=kml_write(kml,fid,indent)

           if ~exist('fid','var') || isempty(fid)
               fid=1;
           end
           if ~exist('indent','var') || isempty(indent)
               indent='';
           end

%  loop over the placemarks

            for i=1:numel(kml)
                if ~isempty(kml(i).id)
                    fprintf(fid,'%s<Placemark id="%s">\n',indent,kml(i).id);
                else
                    fprintf(fid,'%s<Placemark>\n',indent);
                end
                kml_write@kml_feature(kml(i),fid,indent);

%  loop over the geometry elements for each placemark

                for j=1:min(1,numel(kml(i).geometry))
                    if ~isempty(kml(i).geometry(j))
                        if isa(kml(i).geometry(j),'kml_geometry')
                            kml_write(kml(i).geometry(j),fid,[indent '  ']);
                        else
                            warning('kml(%d).geometry(%d) is a ''%s'' class object, not ''%s''.',...
                                i,j,class(kml(i).geometry(j)),'kml_geometry');
                        end
                    end
                end

                fprintf(fid,'%s</Placemark>\n',indent);
            end

        end
        
    end
    
end

