%
%  definition for the kml_style sub (derived) class.
%
%  [kml]=kml_style(varargin)
%
%  where the optional varargin and defaults are:
%    id            (char, style id, '')
%    icon          (char, icon style, '')
%    label         (char, label style, '')
%    line          (char, line style, '')
%    poly          (char, poly style, '')
%    balloon       (char, balloon style, '')
%    list          (char, list style, '')
%
%  note that zero arguments constructs a default instance; one
%  argument of the class copies the instance; and two or more
%  arguments constructs a new instance from the arguments.
%
classdef kml_style < kml_styleselector
    properties
%         icon      =kml_iconstyle.empty();
%         label     =kml_labelstyle.empty();
        icon      =[];
        label     =[];
        line      =kml_linestyle.empty();
        poly      =kml_polystyle.empty();
%         balloon   =kml_balloonstyle.empty();
%         list      =kml_liststyle.empty();
        balloon   =[];
        list      =[];
    end
    
    methods
        function [kml]=kml_style(varargin)

            kml=kml@kml_styleselector(varargin{:});

            switch nargin

%  create a default object

                case 0

%  copy the object or create the object from the input

                otherwise
                    if (nargin == 1) && isa(varargin{1},class(kml))
                        kml=varargin{1};

                    else
                        fnames=fieldnames(kml);

                        for i=length(fieldnames(kml_styleselector()))+1:min(nargin,length(fnames))
                            if isa(varargin{i},class(kml.(fnames{i})))
                                if ~isempty(varargin{i})
                                    kml.(fnames{i})=varargin{i};
                                end
                            else
                                if ~isempty(inputname(i))
                                    warning('Argument ''%s'' for field ''%s'' is a ''%s'' class object, not ''%s''.',...
                                        inputname(i),fnames{i},class(varargin{i}),class(kml.(fnames{i})));
                                else
                                    warning('Argument %d for field ''%s'' is a ''%s'' class object, not ''%s''.',...
                                        i           ,fnames{i},class(varargin{i}),class(kml.(fnames{i})));
                                end
                            end
                        end
                    end

            end

        end

%  display the object

        function []=disp(kml)

            for i=1:numel(kml)
                disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
                    class(kml),inputname(1),string_dim(kml,i)));
                disp@kml_styleselector(kml(i));
                disp(sprintf('          icon: %s %s'   ,string_size(kml(i).icon),...
                             class(kml(i).icon)));
                disp(sprintf('         label: %s %s'   ,string_size(kml(i).label),...
                             class(kml(i).label)));
                disp(sprintf('          line: %s %s'   ,string_size(kml(i).line),...
                             class(kml(i).line)));
                disp(sprintf('          poly: %s %s'   ,string_size(kml(i).poly),...
                             class(kml(i).poly)));
                disp(sprintf('       balloon: %s %s'   ,string_size(kml(i).balloon),...
                             class(kml(i).balloon)));
                disp(sprintf('          list: %s %s\n' ,string_size(kml(i).list),...
                             class(kml(i).list)));
            end

        end

%  write the object

        function []=kml_write(kml,fid,indent)

           if ~exist('fid','var') || isempty(fid)
               fid=1;
           end
           if ~exist('indent','var') || isempty(indent)
               indent='';
           end

%  loop over the styles

            for i=1:numel(kml)
                if ~isempty(kml(i).id)
                    fprintf(fid,'%s<Style id="%s">\n',indent,kml(i).id);
                else
                    fprintf(fid,'%s<Style>\n',indent);
                end
                kml_write@kml_styleselector(kml(i),fid,indent);
%                 if isa(kml(i).icon,'kml_iconstyle')
%                     kml_write(kml(i).icon,fid,[indent '    ']);
%                 else
%                     warning('kml(%d).icon is a ''%s'' class object, not ''%s''.',...
%                         i,class(kml(i).icon),'kml_iconstyle');
%                 end
%                 if isa(kml(i).label,'kml_labelstyle')
%                     kml_write(kml(i).label,fid,[indent '    ']);
%                 else
%                     warning('kml(%d).label is a ''%s'' class object, not ''%s''.',...
%                         i,class(kml(i).label),'kml_labelstyle');
%                 end
                if isa(kml(i).line,'kml_linestyle')
                    kml_write(kml(i).line,fid,[indent '    ']);
                else
                    warning('kml(%d).line is a ''%s'' class object, not ''%s''.',...
                        i,class(kml(i).line),'kml_linestyle');
                end
                if isa(kml(i).poly,'kml_polystyle')
                    kml_write(kml(i).poly,fid,[indent '    ']);
                else
                    warning('kml(%d).poly is a ''%s'' class object, not ''%s''.',...
                        i,class(kml(i).poly),'kml_polystyle');
                end
%                 if isa(kml(i).balloon,'kml_balloonstyle')
%                     kml_write(kml(i).balloon,fid,[indent '    ']);
%                 else
%                     warning('kml(%d).balloon is a ''%s'' class object, not ''%s''.',...
%                         i,class(kml(i).balloon),'kml_balloonstyle');
%                 end
%                 if isa(kml(i).list,'kml_liststyle')
%                     kml_write(kml(i).list,fid,[indent '    ']);
%                 else
%                     warning('kml(%d).list is a ''%s'' class object, not ''%s''.',...
%                         i,class(kml(i).list),'kml_liststyle');
%                 end
                fprintf(fid,'%s</Style>\n',indent);
            end

        end
        
    end
    
end

