%
%  definition for the kml_linestyle sub (derived) class.
%
%  [kml]=kml_linestyle(varargin)
%
%  where the optional varargin and defaults are:
%    id            (char, linestyle id, '')
%    color         (char, opacity/color in hex aabbggrr, 'ffffffff')
%    colormode     (char, color mode , 'normal')
%    width         (numeric, line width (in pixels), 1)
%
%  note that zero arguments constructs a default instance; one
%  argument of the class copies the instance; and two or more
%  arguments constructs a new instance from the arguments.
%
classdef kml_linestyle < kml_colorstyle
    properties
        width     =1;
    end
    
    methods
        function [kml]=kml_linestyle(varargin)

            kml=kml@kml_colorstyle(varargin{:});

            switch nargin

%  create a default object

                case 0

%  copy the object or create the object from the input

                otherwise
                    if (nargin == 1) && isa(varargin{1},class(kml))
                        kml=varargin{1};

                    else
                        fnames=fieldnames(kml);

                        for i=length(fieldnames(kml_colorstyle()))+1:min(nargin,length(fnames))
                            if isa(varargin{i},class(kml.(fnames{i})))
                                if ~isempty(varargin{i})
                                    kml.(fnames{i})=varargin{i};
                                end
                            else
                                if ~isempty(inputname(i))
                                    warning('Argument ''%s'' for field ''%s'' is a ''%s'' class object, not ''%s''.',...
                                        inputname(i),fnames{i},class(varargin{i}),class(kml.(fnames{i})));
                                else
                                    warning('Argument %d for field ''%s'' is a ''%s'' class object, not ''%s''.',...
                                        i           ,fnames{i},class(varargin{i}),class(kml.(fnames{i})));
                                end
                            end
                        end
                    end

            end

        end

%  display the object

        function []=disp(kml)

            for i=1:numel(kml)
                disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
                    class(kml),inputname(1),string_dim(kml,i)));
                disp@kml_colorstyle(kml(i));
                disp(sprintf('         width: %d\n'    ,kml(i).width));
            end

        end

%  write the object

        function []=kml_write(kml,fid,indent)

           if ~exist('fid','var') || isempty(fid)
               fid=1;
           end
           if ~exist('indent','var') || isempty(indent)
               indent='';
           end

%  loop over the linestyles

            for i=1:numel(kml)
                if ~isempty(kml(i).id)
                    fprintf(fid,'%s<LineStyle id="%s">\n',indent,kml(i).id);
                else
                    fprintf(fid,'%s<LineStyle>\n',indent);
                end
                kml_write@kml_colorstyle(kml(i),fid,indent);
                fprintf(fid,'%s  <width>%d</width>\n',indent,kml(i).width);
                fprintf(fid,'%s</LineStyle>\n',indent);
            end

        end
        
    end
    
end

