function md=loadresultsfromdisk(md,filename)
%LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
%
%   Usage:
%      md=loadresultsfromdisk(md,filename);

%We convert all results to m/a units, from m/s

if ((nargin~=2) | (nargout~=1)),
	help loadresultsfromdisk;
	error('loadresultsfromdisk: error message.');
end


md.results=parseresultsfromdisk(filename);

%Check result is consistent
disp(sprintf('%s\n','checking result consistency'));

if ~isresultconsistent(md),
	disp('!! results not consistent correct the model !!') %it would be very cruel to put an error, it would kill the computed results (even if not consistent...)
end
