/*!\file Result.cpp
 * \brief: implementation of the Result object
 */


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./Result.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./ParameterInputs.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"

Result::Result(){
	return;
}

#undef __FUNCT__ 
#define __FUNCT__ "Result::Result"
Result::Result(int result_id,double result_time,int result_step,char* result_fieldname,Vec result_field){

	id=result_id;
	time=result_time;
	step=result_step;
	
	if(!result_fieldname){
		throw  ErrorException(__FUNCT__," NULL fieldname in constructor argument");
	}
	else{
		fieldname=(char*)xmalloc((strlen(result_fieldname)+1)*sizeof(char));
		strcpy(fieldname,result_fieldname);
	}

	field=result_field; //do not copy, as the results are large in memory size.
	dfield=NULL;
}

#undef __FUNCT__ 
#define __FUNCT__ "Result::Result"
Result::Result(int result_id,double result_time,int result_step,char* result_fieldname,double* result_field,int result_size){

	id=result_id;
	time=result_time;
	step=result_step;
	
	if(!result_fieldname){
		throw  ErrorException(__FUNCT__," NULL fieldname in constructor argument");
	}
	else{
		fieldname=(char*)xmalloc((strlen(result_fieldname)+1)*sizeof(char));
		strcpy(fieldname,result_fieldname);
	}

	dfield=result_field; //do not copy, as the results are large in memory size.
	size=result_size;
	field=NULL;
}


Result::~Result(){
	xfree((void**)&fieldname);
	VecFree(&field);
	xfree((void**)&dfield);
}
		
void Result::Echo(void){

	printf("Result:\n");
	printf("   id: %i\n",id);
	printf("   time: %g\n",time);
	printf("   step: %i\n",step);
	printf("   field name: %s\n",fieldname);
	if(field){
		printf("   field pointer %p\n",field);
	}
	else{
		printf("   field pointer %p\n",dfield);
		printf("   field size %i\n",size);
	}
}
	
#undef __FUNCT__ 
#define __FUNCT__ "Result::Marshall"
void  Result::Marshall(char** pmarshalled_dataset){

	throw  ErrorException(__FUNCT__," not supported yet!");

}
	
#undef __FUNCT__ 
#define __FUNCT__ "Result::MarshallSize"
int   Result::MarshallSize(){

	throw  ErrorException(__FUNCT__," not supported yet!");
}

char* Result::GetName(void){
	return "result";
}
		

#undef __FUNCT__ 
#define __FUNCT__ "Result::Demarshall"
void  Result::Demarshall(char** pmarshalled_dataset){

	throw  ErrorException(__FUNCT__," not supported yet!");
}

int Result::Enum(void){

	return ResultEnum();

}
int    Result::GetId(void){ return id; }

int    Result::MyRank(void){ 
	extern int my_rank;

	return my_rank; 
}

double Result::GetTime(){
	return time;
}

int    Result::GetStep(){
	return step;
}

char*    Result::GetFieldName(){
	return fieldname;
}
		
void   Result::WriteData(FILE* fid){

	int length;

	/*First write field name :*/
	length=(strlen(fieldname)+1)*sizeof(char);

	fwrite(&length,sizeof(int),1,fid);
	fwrite(fieldname,length,1,fid);

	/*Now write time and step: */
	fwrite(&time,sizeof(double),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*Now write field: */
	fwrite(&size,sizeof(int),1,fid);
	fwrite(dfield,size*sizeof(double),1,fid);
}


void  Result::GetField(Vec* pfield){
	*pfield=field;
}
		
void  Result::GetField(double** pfield){
	*pfield=dfield;
}

Object* Result::copy() {
	return new Result(*this); 
}
