%Quick documentation for ISSM

%First get ISSM dir: 
ISSM_DIR=issmdir;

disp(sprintf('\n%s%s%s','  The following documentations are available in ',ISSM_DIR,'/doc/'));
disp(sprintf('%s','	   userguide: how to use ISSM, quick tutorial'));
disp(sprintf('%s','	   theoryguide: theory behind the ISSM models'));
disp(sprintf('%s\n','	   developperguide: documented API and source code'));
disp(sprintf('%s','  Example: how to create a square ice shelf'));
disp(sprintf('%s','	   go to ',ISSM_DIR,'/examples/SquareIceshelf'));
disp(sprintf('%s','	   md=model;                                %creates a new empty model structure'));
disp(sprintf('%s','	   md=mesh(md,''DomainOutline.exp'',50000);   %creates a mesh of the domain outline with a resolution of 50000m'));
disp(sprintf('%s','	   md=geography(md,''all'','''');               %defines the glacier system as an ice shelf (no island)'));
disp(sprintf('%s','	   md=parameterize(md,''Square.par'');        %fills all the other fields of the model'));
disp(sprintf('%s','	   md=setelementstype(md,''macayeal'',''all''); %defines all elements as MacAyeal''s'));
disp(sprintf('%s','	   md=solve(md,''analysis_type'',''diagnostic'',''package'',''ice'');   %generate the velocity field of the ice shelf using the solver ICE'));
disp(sprintf('%s','	   plotmodel(md,''data'',''vel'');              %displays the velocity (type plotdoc for plotmodel help)'));
