%%
%  create kml linestrings for the flagged partition edges.
%
%  []=kml_part_flagedges(fid,md,params)
%
%  where the required input is:
%    fid           (char, file ID of .kml file)
%    md            (model, model class object)
%
%  the optional input is:
%    params        (string/numeric, parameter names and values)
%
%  and the optional input is:
%    alt           (numeric, altitude for polygons, default 10000)
%    prtplt        (char, 'off'/'no' for partition segment plot)
%
function []=kml_part_flagedges(varargin)

if ~nargin
    help kml_part_flagedges
    return
end

%%  process input data

iarg=1;
if (nargin >= 1)
    fid=varargin{1};
end
if ~exist('fid','var') || isempty(fid) || (fid < 0)
    error('File ID ''%d'' must be open.',fid);
end

iarg=iarg+1;
if (nargin >= 2)
    md=varargin{2};
end
if ~exist('md','var') || isempty(md) || ~isa(md,'model')
    error(['Model ''' inputname(iarg) ''' is unrecognized class ''' class(md) '''.']);
end

%  parameters

iarg=iarg+1;
while (iarg <= nargin-1)
    if ischar(varargin{iarg})
        eval([varargin{iarg} '=varargin{iarg+1};']);
        if (numel(varargin{iarg+1}) <= 20)
            disp([varargin{iarg} '=' any2str(varargin{iarg+1}) ';']);
        else
            disp([varargin{iarg} '=' string_size(varargin{iarg+1}) ' ' class(varargin{iarg+1}) ';']);
        end
    else
        error(['''' any2str(varargin{iarg}) ''' is not a parameter name.']);
    end
    iarg=iarg+2;
end

if ~exist('alt','var')
    alt=10000;
end

%%  write folder for partition segments

if (~exist('prtplt','var') || strncmpi(prtplt,'on' ,2) || strncmpi(prtplt,'y',1)) && ...
    md.npart
    [xseg,yseg]=flagedges(md.elements,md.x,md.y,md.part);
    fprintf(fid,'    <Folder>\n');
    fprintf(fid,'      <name>Partition Segments</name>\n');
    fprintf(fid,'      <visibility>1</visibility>\n');
    fprintf(fid,'      <description>Partitions=%d, Segments=%d</description>\n',...
        md.npart,size(xseg,1));

%  write each segment as a linestring

    disp(['Writing ' num2str(size(xseg,1)) ' partition segments as KML linestrings.']);
    for i=1:size(xseg,1)
        fprintf(fid,'      <Placemark>\n');
        fprintf(fid,'        <name>Segment %d</name>\n',i);
        fprintf(fid,'        <visibility>1</visibility>\n');
        fprintf(fid,'        <styleUrl>#RedLineRedPoly</styleUrl>\n');
        fprintf(fid,'        <LineString>\n');
        fprintf(fid,'          <extrude>1</extrude>\n');
        fprintf(fid,'          <tessellate>1</tessellate>\n');
        fprintf(fid,'          <altitudeMode>relativeToGround</altitudeMode>\n');
        fprintf(fid,'          <coordinates>\n');
        for j=1:2
            [lat(j),long(j)]=mapxy(xseg(i,j),yseg(i,j),'s');
            fprintf(fid,'            %0.16g,%0.16g,%0.16g\n',long(j),lat(j),alt);
        end

        fprintf(fid,'          </coordinates>\n');
        fprintf(fid,'        </LineString>\n');
        fprintf(fid,'      </Placemark>\n');
    end
    fprintf(fid,'    </Folder>\n');
end

end

