/*\file TriaSearch.c
 *\brief: TriaSearch module. See TriaSearchx for more details.
 */
#include "./TriaSearch.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	int i;

	/*input: */
	double* index=NULL;
	int     nel;
	int     dummy;

	double* x=NULL;
	double* y=NULL;
	int     nods;

	double* x0=NULL;
	double* y0=NULL;
	int     numberofgrids;

	/* output: */
	double*  tria=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&TriaSearchUsage);

	/*Input datasets: */
	FetchData(&index,&nel,&dummy,INDEXHANDLE);
	FetchData(&x,&nods,XHANDLE);
	FetchData(&y,&nods,YHANDLE);
	FetchData(&x0,&numberofgrids,X0HANDLE);
	FetchData(&y0,&numberofgrids,Y0HANDLE);

	/* Echo: {{{1*/
	//printf("(x0,y0)=(%g,%g)\n",x0,y0);
	/*}}}*/

	/* Run core computations: */
	TriaSearchx(&tria,index,nel,x,y,nods,x0,y0,numberofgrids);

	/* c to matlab: */
	for(i=0;i<numberofgrids;i++)tria[i]++;

	/*Write data: */
	WriteData(TRIA,tria,numberofgrids);

	/*end module: */
	MODULEEND();
}

void TriaSearchUsage(void)
{
	_printf_(true,"TriaSearch- find triangle holding a point (x0,y0) in a mesh\n");
	_printf_(true,"\n");
	_printf_(true,"   Usage:\n");
	_printf_(true,"         tria=TriaSearch(index,x,y,x0,y0);\n");
	_printf_(true,"      index,x,y: mesh triangulatrion\n");
	_printf_(true,"      x0,y0: coordinates of the point for which we are trying to find a triangle\n");
	_printf_(true,"      x0,y0 can be an array of points\n");
	_printf_(true,"\n");
}
