/*\file SpcNodes.c
 *\brief: build degrees of freedom for every node.
 */

#include "./SpcNodes.h"


void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Nodes* nodes=NULL;
	Constraints* constraints=NULL;
	int      analysis_type;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&SpcNodesUsage);

	/*Input datasets: */
	FetchData((DataSet**)&nodes,NODESIN);
	FetchData((DataSet**)&constraints,CONSTRAINTS);
	FetchData(&analysis_type,ANALYSISTYPE);
	
	/*!Generate internal degree of freedom numbers: */
	SpcNodesx(nodes,constraints,analysis_type); 

	/*write output datasets: */
	WriteData(NODES,nodes);

	/*Free ressources: */
	delete nodes;
	delete constraints;

	/*end module: */
	MODULEEND();
}

void SpcNodesUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [m.node]=%s(m.nodes,m.constraints);\n",__FUNCT__);
	_printf_(true,"\n");
}
