/*\file Orth.c
 *\brief: orthogonalize searching directions for inverse control methods.
 */

#include "./Orth.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vec gradj=NULL;
	Vec oldgradj=NULL;

	/* output datasets: */
	Vec newgradj=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&OrthUsage);

	/*Input datasets: */
	FetchData(&gradj,GRADJ);
	FetchData(&oldgradj,OLDGRADJ);

	/*!Reduce load from g to f size: */
	Orthx(&newgradj, gradj,oldgradj);

	/*write output datasets: */
	WriteData(NEWGRADJ,newgradj);

	/*Free ressources: */
	VecFree(&gradj);
	VecFree(&oldgradj);
	VecFree(&newgradj);

	/*end module: */
	MODULEEND();
}

void OrthUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [newgradj] = %s(gradj,oldgradj);\n",__FUNCT__);
	_printf_(true,"\n");
}
