/*\file NodeConnectivity.c
 *\brief: build node connectivity from elements. 
 */

#include "./NodeConnectivity.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*inputs: */
	double* elements=NULL;
	int     nel,nods;

	/*outputs: */
	double* connectivity=NULL;
	int     width;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&NodeConnectivityUsage);
        
	/*Input datasets: */
	FetchData(&elements,&nel,NULL,ELEMENTS);
	FetchData(&nods,NUMNODES);

	/*!Generate internal degree of freedom numbers: */
	NodeConnectivityx(&connectivity, &width,elements,nel, nods);

	/*write output datasets: */
	WriteData(CONNECTIVITY,connectivity,nods,width);

	/*Free ressources: */
	xfree((void**)&elements);

	/*end module: */
	MODULEEND();
}

void NodeConnectivityUsage(void) {
	_printf_(true,"\n");
	_printf_(true,"   usage: connectivity = %s(elements, numnodes);\n",__FUNCT__);
	_printf_(true,"\n");
}
