/*\file Mergesolutionfromftog.c
 *\brief: merge solution back from f set into g set
 */

#include "./Mergesolutionfromftog.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	bool        flag_ys0;
	Vec         uf         = NULL;
	Vec         ys         = NULL;
	NodeSets   *nodesets   = NULL;
	Parameters *parameters = NULL;

	/* output datasets: */
	Vec ug=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if((nlhs!=NLHS) || (nrhs!=4 && nrhs!=5)){
		MergesolutionfromftogUsage();
		_error_(" usage. See above");
	}

	/*Input datasets: */
	FetchData(&uf,UF);
	FetchData(&ys,YS);
	FetchNodeSets(&nodesets,NODESETS);
	FetchParams(&parameters,PARAMETERS);

	/*!Reduce vector: */
	if (nrhs==4){
		Mergesolutionfromftogx(&ug, uf,ys,nodesets,parameters);
	}
	else{
		FetchData(&flag_ys0,YSFLAG);
		Mergesolutionfromftogx(&ug, uf,ys,nodesets,parameters,flag_ys0);
	}

	/*write output datasets: */
	WriteData(UG,ug);

	/*Free ressources: */
	VecFree(&uf);
	VecFree(&ug);
	VecFree(&ys);
	delete nodesets;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void MergesolutionfromftogUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [ug] = %s(uf,ys,nodesets,parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
