/*\file InputDuplicate.c
 *\brief: duplicate input
 */

#include "./InputDuplicate.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	int      original_enum,new_enum; 

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputDuplicateUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	
	FetchData(&original_enum,ORIGINALENUM);
	FetchData(&new_enum,NEWENUM);

	/*!Call core code: */
	InputDuplicatex( elements, nodes, vertices, loads, materials,parameters,original_enum, new_enum);

	/*write output : */
	WriteData(ELEMENTSOUT,elements);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	/*end module: */
	MODULEEND();

}

void InputDuplicateUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters, original_enum,new_enum);\n",__FUNCT__);
	_printf_(true,"\n");
}
